package gov.va.med.mhv.integration.phr.util;

import gov.va.med.mhv.integration.phr.stage.transfer.StageEntity;
import gov.va.med.mhv.integration.phr.stage.transfer.StageEntityAK;
import gov.va.med.mhv.integration.phr.stage.transfer.StageRecordStatusType;
import gov.va.med.mhv.integration.phr.transfer.DataLoadResponse;

import java.util.List;

/**
 * User: Rob Murtha
 */
public class StageHelper {
    public static StageEntityAK createAK(DataLoadResponse response) {
        return new StageEntityAK(
                response.getIcn(),
                response.getRequestMsgCtrlId(),
                response.getResponseMsgCtrlId());
    }

    public static void markForDelete(List<? extends StageEntity> instances) {
        for (StageEntity instance : instances) {
            instance.setRecordStatus(StageRecordStatusType.DELETE);
        }
    }

    public static void setExtractStatus(List<? extends StageEntity> instances, String status) {
        for (StageEntity instance : instances) {
                instance.setExtractStatus(status);
        }
    }


}
